/******************************************************************************
 *
 * Copyright (c) 2003-2004 PalmSource, Inc. All rights reserved.
 *
 * File: stdint.h
 *
 * Release: Palm OS Developer Suite 5 SDK (68K) 4.0
 *
 * Description:
 *
 *
 *****************************************************************************/


#ifndef __PALMSOURCE_CC_HDR_STDINT_H
#define __PALMSOURCE_CC_HDR_STDINT_H


#ifdef __cplusplus
namespace std {
#endif

typedef	signed char		int8_t;
typedef	signed short		int16_t;
typedef signed long		int32_t;
typedef signed long long	int64_t;

typedef	unsigned char		uint8_t;
typedef	unsigned short		uint16_t;
typedef unsigned long		uint32_t;
typedef unsigned long long	uint64_t;

typedef	int8_t		int_least8_t;
typedef	int16_t		int_least16_t;
typedef int32_t		int_least32_t;
typedef	int64_t		int_least64_t;

typedef	uint8_t		uint_least8_t;
typedef	uint16_t	uint_least16_t;
typedef uint32_t	uint_least32_t;
typedef uint64_t	uint_least64_t;

typedef	int8_t		int_fast8_t;
typedef	int16_t		int_fast16_t;
typedef int32_t		int_fast32_t;
typedef int64_t		int_fast64_t;

typedef	int8_t		uint_fast8_t;
typedef	int16_t		uint_fast16_t;
typedef int32_t		uint_fast32_t;
typedef int64_t		uint_fast64_t;

typedef signed long		intptr_t;
typedef unsigned long		uintptr_t;

typedef signed long long	intmax_t;
typedef unsigned long long	uintmax_t;

#ifdef __cplusplus
} /* namespace std */
#endif /* __cplusplus */

#define INT8_MIN	(-127 - 1)
#define INT8_MAX	 127
#define UINT8_MAX	 255

#define INT16_MIN	(-32767 - 1)
#define INT16_MAX	 32767
#define UINT16_MAX	 65535U

#define INT32_MIN	(-2147483647 - 1)
#define INT32_MAX	 2147483647
#define UINT32_MAX	 4294967295U

#define INT64_MIN	(-9223372036854775807LL - 1)
#define INT64_MAX	 9223372036854775807LL
#define UINT64_MAX	 18446744073709551615ULL

#define INT_LEAST8_MIN		INT8_MIN
#define INT_LEAST8_MAX		INT8_MAX
#define UINT_LEAST8_MAX		UINT8_MAX

#define INT_LEAST16_MIN		INT16_MIN
#define INT_LEAST16_MAX		INT16_MAX
#define UINT_LEAST16_MAX	UINT16_MAX

#define INT_LEAST32_MIN		INT32_MIN
#define INT_LEAST32_MAX		INT32_MAX
#define UINT_LEAST32_MAX	UINT32_MAX

#define INT_LEAST64_MIN		INT64_MIN
#define INT_LEAST64_MAX		INT64_MAX
#define UINT_LEAST64_MAX	UINT64_MAX

#define INT_LEAST8_MIN		INT8_MIN
#define INT_FAST8_MAX		INT8_MAX
#define UINT_FAST8_MAX		UINT8_MAX

#define INT_FAST16_MIN		INT16_MIN
#define INT_FAST16_MAX		INT16_MAX
#define UINT_FAST16_MAX		UINT16_MAX

#define INT_FAST32_MIN		INT32_MIN
#define INT_FAST32_MAX		INT32_MAX
#define UINT_FAST32_MAX		UINT32_MAX

#define INT_FAST64_MIN		INT64_MIN
#define INT_FAST64_MAX		INT64_MAX
#define UINT_FAST64_MAX		UINT64_MAX

#define INTPTR_MIN		INT32_MIN
#define INTPTR_MAX		INT32_MAX
#define UINTPTR_MAX		UINT32_MAX

#define INTMAX_MIN		INT64_MIN
#define INTMAX_MAX		INT64_MAX
#define UINTMAX_MAX		UINT64_MAX

#define PTRDIFF_MIN		INT32_MIN
#define PTRDIFF_MAX		INT32_MAX

#define SIZE_MAX		UINT32_MAX

#define WCHAR_MIN		UINT32_MIN
#define WCHAR_MAX		UINT32_MAX

#define WINT_MIN		INT32_MIN
#define WINT_MAX		INT32_MAX

#define INT8_C(value)		(int8_t)(value)
#define UINT8_C(value)		(uint8_t)(value)
#define INT16_C(value)		(int16_t)(value)
#define UINT16_C(value)		(uint16_t)(value)
#define INT32_C(value)		(int32_t)(value)
#define UINT32_C(value)		(uint32_t)(value ## U)
#define INT64_C(value)		(int64_t)(value ## LL)
#define UINT64_C(value)		(uint64_t)(value ## ULL)

#define INTMAX_C(value)		(intmax_t)(value ## LL)
#define UINTMAX_C(value)	(uintmax_t)(value ## ULL)

#endif /* __PALMSOURCE_CC_HDR_STDINT_H */


#if defined(__cplusplus) && !defined(__PALMSOURCE_CC_HDR_STDINT_H_NO_HOIST)
using std::int8_t;
using std::int16_t;
using std::int32_t;
using std::int64_t;

using std::uint8_t;
using std::uint16_t;
using std::uint32_t;
using std::uint64_t;

using std::int_least8_t;
using std::int_least16_t;
using std::int_least32_t;
using std::int_least64_t;

using std::uint_least8_t;
using std::uint_least16_t;
using std::uint_least32_t;
using std::uint_least64_t;

using std::int_fast8_t;
using std::int_fast16_t;
using std::int_fast32_t;
using std::int_fast64_t;

using std::uint_fast8_t;
using std::uint_fast16_t;
using std::uint_fast32_t;
using std::uint_fast64_t;

using std::intptr_t;
using std::uintptr_t;
using std::intmax_t;
using std::uintmax_t;
#endif /* __cplusplus && !__PALMSOURCE_CC_HDR_STDINT_H_NO_HOIST */
